/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks.reinforced;

import net.geforcemods.securitycraft.api.IIntersectable;
import net.geforcemods.securitycraft.blocks.BlockInventoryScanner;
import net.geforcemods.securitycraft.blocks.BlockKeycardReader;
import net.geforcemods.securitycraft.blocks.BlockKeypad;
import net.geforcemods.securitycraft.blocks.BlockLaserBlock;
import net.geforcemods.securitycraft.blocks.BlockRetinalScanner;
import net.geforcemods.securitycraft.misc.CustomDamageSources;
import net.geforcemods.securitycraft.tileentity.TileEntityOwnable;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFenceGate;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

public class BlockReinforcedFenceGate
extends BlockFenceGate
implements ITileEntityProvider,
IIntersectable {
    public BlockReinforcedFenceGate() {
        super(BlockPlanks.EnumType.OAK);
        ObfuscationReflectionHelper.setPrivateValue(Block.class, (Object)this, (Object)Material.field_151573_f, (int)18);
        this.func_149672_a(SoundType.field_185852_e);
    }

    public boolean canEntityDestroy(IBlockState state, IBlockAccess world, BlockPos pos, Entity entity) {
        return !(entity instanceof EntityWither);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        return false;
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        super.func_180663_b(world, pos, state);
        world.func_175713_t(pos);
    }

    @Override
    public void onEntityIntersected(World world, BlockPos pos, Entity entity) {
        if (BlockUtils.getBlockPropertyAsBoolean(world, pos, field_176466_a)) {
            return;
        }
        if (entity instanceof EntityItem) {
            return;
        }
        if (entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            if (((TileEntityOwnable)world.func_175625_s(pos)).getOwner().isOwner(player)) {
                return;
            }
        } else if (entity instanceof EntityCreeper) {
            EntityCreeper creeper = (EntityCreeper)entity;
            EntityLightningBolt lightning = new EntityLightningBolt(world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), true);
            creeper.func_70077_a(lightning);
            return;
        }
        entity.func_70097_a((DamageSource)CustomDamageSources.electricity, 6.0f);
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block) {
        if (!world.field_72995_K) {
            boolean isPoweredSCBlock;
            boolean bl = isPoweredSCBlock = this.isSCBlock(block) && world.func_175640_z(pos);
            if (isPoweredSCBlock || block.func_176223_P().func_185897_m()) {
                if (isPoweredSCBlock && !((Boolean)state.func_177229_b((IProperty)field_176466_a)).booleanValue() && !((Boolean)state.func_177229_b((IProperty)field_176465_b)).booleanValue()) {
                    world.func_180501_a(pos, state.func_177226_a((IProperty)field_176466_a, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)field_176465_b, (Comparable)Boolean.valueOf(true)), 2);
                    world.func_180498_a((EntityPlayer)null, 1008, pos, 0);
                } else if (!isPoweredSCBlock && ((Boolean)state.func_177229_b((IProperty)field_176466_a)).booleanValue() && ((Boolean)state.func_177229_b((IProperty)field_176465_b)).booleanValue()) {
                    world.func_180501_a(pos, state.func_177226_a((IProperty)field_176466_a, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)field_176465_b, (Comparable)Boolean.valueOf(false)), 2);
                    world.func_180498_a((EntityPlayer)null, 1014, pos, 0);
                } else if (isPoweredSCBlock != (Boolean)state.func_177229_b((IProperty)field_176465_b)) {
                    world.func_180501_a(pos, state.func_177226_a((IProperty)field_176465_b, (Comparable)Boolean.valueOf(isPoweredSCBlock)), 2);
                }
            }
        }
    }

    private boolean isSCBlock(Block block) {
        return block instanceof BlockLaserBlock || block instanceof BlockRetinalScanner || block instanceof BlockKeypad || block instanceof BlockKeycardReader || block instanceof BlockInventoryScanner;
    }

    public boolean func_189539_a(IBlockState state, World world, BlockPos pos, int id, int param) {
        super.func_189539_a(state, world, pos, id, param);
        TileEntity tileentity = world.func_175625_s(pos);
        return tileentity != null ? tileentity.func_145842_c(id, param) : false;
    }

    @Override
    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityOwnable().intersectsEntities();
    }
}

